/*
 * Decompiled with CFR 0.152.
 */
package net.wsttech.gm.utils;

import net.wsttech.gm.utils.ByteUtils;

public final class PKCSUtils {
    public static byte[] padding(byte[] data, String pkcs) {
        switch (pkcs) {
            case "pkcs5": 
            case "PKCS5": {
                return PKCSUtils.PKCS5Padding(data);
            }
            case "pkcs7": 
            case "PKCS7": {
                return PKCSUtils.PKCS7Padding(data);
            }
            case "no": {
                return data;
            }
        }
        throw new RuntimeException("PKCS IS INVALID");
    }

    private static byte[] PKCS7Padding(byte[] data) {
        int paddingLen = 16 - data.length % 16;
        byte[] padding = PKCSUtils.padding(paddingLen);
        byte[] bytes = ByteUtils.mergeBytes(data, padding);
        return bytes;
    }

    private static byte[] PKCS5Padding(byte[] data) {
        int paddingLen = 8 - data.length % 8;
        byte[] padding = PKCSUtils.padding(paddingLen);
        byte[] bytes = ByteUtils.mergeBytes(data, padding);
        return bytes;
    }

    public static byte[] PKCSUnPadding(byte[] data) {
        byte last = data[data.length - 1];
        byte[] res = new byte[data.length - last];
        System.arraycopy(data, 0, res, 0, res.length);
        return res;
    }

    private static byte[] padding(int len) {
        byte[] forPad = new byte[len];
        switch (len) {
            case 1: {
                forPad[0] = 1;
                break;
            }
            case 2: {
                forPad[0] = 2;
                break;
            }
            case 3: {
                forPad[0] = 3;
                break;
            }
            case 4: {
                forPad[0] = 4;
                break;
            }
            case 5: {
                forPad[0] = 5;
                break;
            }
            case 6: {
                forPad[0] = 6;
                break;
            }
            case 7: {
                forPad[0] = 7;
                break;
            }
            case 8: {
                forPad[0] = 8;
                break;
            }
            case 9: {
                forPad[0] = 9;
                break;
            }
            case 10: {
                forPad[0] = 10;
                break;
            }
            case 11: {
                forPad[0] = 11;
                break;
            }
            case 12: {
                forPad[0] = 12;
                break;
            }
            case 13: {
                forPad[0] = 13;
                break;
            }
            case 14: {
                forPad[0] = 14;
                break;
            }
            case 15: {
                forPad[0] = 15;
                break;
            }
            default: {
                forPad[0] = 16;
            }
        }
        for (int i = 1; i < len; ++i) {
            forPad[i] = forPad[0];
        }
        return forPad;
    }
}

