/*
 * Decompiled with CFR 0.152.
 */
package net.wsttech.gm.utils;

import java.math.BigInteger;
import net.wsttech.gm.utils.ByteUtils;
import net.wsttech.gm.utils.HexUtils;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1SequenceParser;
import org.bouncycastle.asn1.DERSequence;

public class SM2SignASN1Utils
extends ASN1Object {
    private ASN1Integer r;
    private ASN1Integer s;

    public ASN1Integer getR() {
        return this.r;
    }

    public void setR(ASN1Integer r) {
        this.r = r;
    }

    public ASN1Integer getS() {
        return this.s;
    }

    public void setS(ASN1Integer s) {
        this.s = s;
    }

    public SM2SignASN1Utils(ASN1Integer r, ASN1Integer s) {
        this.r = r;
        this.s = s;
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector vector = new ASN1EncodableVector();
        vector.add((ASN1Encodable)this.r);
        vector.add((ASN1Encodable)this.s);
        return new DERSequence(vector);
    }

    public static byte[] sm2SignToAsn1(String signData) {
        if (signData.length() != 128) {
            throw new RuntimeException("SignData Length Invalid.");
        }
        BigInteger r = new BigInteger(signData.substring(0, 63), 16);
        BigInteger s = new BigInteger(signData.substring(64), 16);
        try {
            SM2SignASN1Utils sm2SignAsn1 = new SM2SignASN1Utils(new ASN1Integer(r), new ASN1Integer(s));
            return sm2SignAsn1.getEncoded();
        }
        catch (Exception e) {
            throw new RuntimeException("ASN.1 Encoding failed.");
        }
    }

    public static String sm2SignToAsn1String(String signData) {
        return ByteUtils.byteToHexString(SM2SignASN1Utils.sm2SignToAsn1(signData));
    }

    public static String parseSm2SignAsn1Object(String asn1String) {
        if (asn1String.length() == 142 || asn1String.length() == 144) {
            StringBuilder sb = new StringBuilder();
            byte[] data = HexUtils.hexStringToBytes(asn1String);
            ASN1InputStream ais = new ASN1InputStream(data);
            try {
                ASN1Primitive primitive;
                while ((primitive = ais.readObject()) != null) {
                    ASN1Encodable encodable;
                    if (!(primitive instanceof ASN1Sequence)) continue;
                    ASN1Sequence sequence = (ASN1Sequence)primitive;
                    ASN1SequenceParser parser = sequence.parser();
                    while ((encodable = parser.readObject()) != null) {
                        primitive = encodable.toASN1Primitive();
                        String temp = String.valueOf(primitive);
                        String s = String.format("%064x", new BigInteger(temp));
                        sb.append(s);
                    }
                }
                return sb.toString().replace("#", "").toUpperCase();
            }
            catch (Exception e) {
                throw new RuntimeException("parse ASN.1 context failed.");
            }
        }
        throw new RuntimeException("ASN.1 DATA Invalid.");
    }

    public static String parseSm2SignAsn1Object(byte[] asn1Bytes) {
        return SM2SignASN1Utils.parseSm2SignAsn1Object(ByteUtils.byteToHexString(asn1Bytes));
    }
}

