package cn.zjquantum.gm.api.request.sm2;

import io.swagger.v3.oas.annotations.media.Schema;

import java.io.Serializable;
@Schema(description = "SM2加密请求参数")
public class SM2EncryptRequest implements Serializable {

    @Schema(description = "公钥")
    private String publicKey;

    @Schema(description = "公钥编码规则（HEX, BASE64）")
    private String keyEncode = "BASE64";

    @Schema(description = "原文（待加密数据）")
    private String plaintext;

    @Schema(description = "原文编码规则（UTF8, HEX, BASE64）")
    private String plaintextEncode = "UTF8";

    @Schema(description = "输出结果编码规则（HEX, BASE64）")
    private String resEncode = "BASE64";

    public SM2EncryptRequest(String publicKey, String keyEncode, String plaintext, String plaintextEncode, String resEncode) {
        this.publicKey = publicKey;
        this.keyEncode = keyEncode;
        this.plaintext = plaintext;
        this.plaintextEncode = plaintextEncode;
        this.resEncode = resEncode;
    }

    public SM2EncryptRequest(String publicKey, String plaintext) {
        this.publicKey = publicKey;
        this.plaintext = plaintext;
    }

    public String getPublicKey() {
        return publicKey;
    }

    public void setPublicKey(String publicKey) {
        this.publicKey = publicKey;
    }

    public String getKeyEncode() {
        return keyEncode;
    }

    public void setKeyEncode(String keyEncode) {
        this.keyEncode = keyEncode;
    }

    public String getPlaintext() {
        return plaintext;
    }

    public void setPlaintext(String plaintext) {
        this.plaintext = plaintext;
    }

    public String getPlaintextEncode() {
        return plaintextEncode;
    }

    public void setPlaintextEncode(String plaintextEncode) {
        this.plaintextEncode = plaintextEncode;
    }

    public String getResEncode() {
        return resEncode;
    }

    public void setResEncode(String resEncode) {
        this.resEncode = resEncode;
    }

}
