package cn.zjquantum.gm.api.request.sm2;

import io.swagger.v3.oas.annotations.media.Schema;

import java.util.List;

@Schema(description = "SM2根据密钥编号获取密钥对请求参数")
public class SM2KeyGenerateByKeyIdsRequest {

    @Schema(description = "密钥编号集合")
    private List<String> keyIds;

    @Schema(description = "输出结果编码规则（HEX, BASE64）")
    private String resEncode = "BASE64";

    public SM2KeyGenerateByKeyIdsRequest(List<String> keyIds, String resEncode) {
        this.keyIds = keyIds;
        this.resEncode = resEncode;
    }

    public SM2KeyGenerateByKeyIdsRequest(List<String> keyIds) {
        this.keyIds = keyIds;
    }

    public List<String> getKeyIds() {
        return keyIds;
    }

    public void setKeyIds(List<String> keyIds) {
        this.keyIds = keyIds;
    }

    public String getResEncode() {
        return resEncode;
    }

    public void setResEncode(String resEncode) {
        this.resEncode = resEncode;
    }
}
