package cn.zjquantum.gm.api.request.sm3;

import io.swagger.v3.oas.annotations.media.Schema;

import java.io.Serializable;

@Schema(description = "SM3摘要计算请求参数")
public class SM3HashRequest implements Serializable {

    @Schema(description = "待计算消息")
    private String message;

    @Schema(description = "待计算消息编码规则（UTF8, HEX, BASE64）")
    private String messageEncode = "UTF8";

    @Schema(description = "输出结果编码规则（UTF8, HEX, BASE64）")
    private String resEncode = "UTF8";

    public SM3HashRequest(String message, String messageEncode, String resEncode) {
        this.message = message;
        this.messageEncode = messageEncode;
        this.resEncode = resEncode;
    }

    public SM3HashRequest(String message) {
        this.message = message;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getMessageEncode() {
        return messageEncode;
    }

    public void setMessageEncode(String messageEncode) {
        this.messageEncode = messageEncode;
    }

    public String getResEncode() {
        return resEncode;
    }

    public void setResEncode(String resEncode) {
        this.resEncode = resEncode;
    }

}
