package cn.zjquantum.gm.api.request.sm4;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;

import java.io.Serializable;

@Schema(description = "SM4解密请求参数")
public class SM4DecryptRequest implements Serializable {

    @Schema(description = "密钥")
    private String key;

    @Schema(description = "密钥编码规则（HEX, BASE64）")
    private String keyEncode = "BASE64";

    @Schema(description = "iv向量，长度16字节")
    @JsonProperty("iv")
    private String iv;

    @Schema(description = "iv向量编码规则（HEX, BASE64）")
    @JsonProperty("ivEncode")
    private String ivEncode = "BASE64";

    @Schema(description = "模式（ECB/CBC）")
    private String mode;

    @Schema(description = "密文（待解密数据）")
    private String ciphertext;

    @Schema(description = "密文编码规则（HEX, BASE64）")
    private String ciphertextEncode = "BASE64";

    @Schema(description = "输出结果编码规则（UTF8, HEX, BASE64）")
    private String resEncode = "UTF8";

    public SM4DecryptRequest(String key, String keyEncode, String iv, String ivEncode, String mode, String ciphertext, String ciphertextEncode, String resEncode) {
        this.key = key;
        this.keyEncode = keyEncode;
        this.iv = iv;
        this.ivEncode = ivEncode;
        this.mode = mode;
        this.ciphertext = ciphertext;
        this.ciphertextEncode = ciphertextEncode;
        this.resEncode = resEncode;
    }

    public SM4DecryptRequest(String key, String iv, String mode, String ciphertext) {
        this.key = key;
        this.iv = iv;
        this.mode = mode;
        this.ciphertext = ciphertext;
    }

    public String getKey() {
        return key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getKeyEncode() {
        return keyEncode;
    }

    public void setKeyEncode(String keyEncode) {
        this.keyEncode = keyEncode;
    }

    public String getIv() {
        return iv;
    }

    public void setIv(String iv) {
        this.iv = iv;
    }

    public String getIvEncode() {
        return ivEncode;
    }

    public void setIvEncode(String ivEncode) {
        this.ivEncode = ivEncode;
    }

    public String getMode() {
        return mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public String getCiphertext() {
        return ciphertext;
    }

    public void setCiphertext(String ciphertext) {
        this.ciphertext = ciphertext;
    }

    public String getCiphertextEncode() {
        return ciphertextEncode;
    }

    public void setCiphertextEncode(String ciphertextEncode) {
        this.ciphertextEncode = ciphertextEncode;
    }

    public String getResEncode() {
        return resEncode;
    }

    public void setResEncode(String resEncode) {
        this.resEncode = resEncode;
    }

}
