package cn.zjquantum.gm.api.request.sm4;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;

import java.io.Serializable;

@Schema(description = "SM4加密请求参数")
public class SM4EncryptRequest implements Serializable {

    @Schema(description = "密钥，16字节")
    private String key;

    @Schema(description = "密钥编码规则（HEX, BASE64）")
    private String keyEncode = "BASE64";

    @Schema(description = "iv向量，16字节")
    @JsonProperty("iv")
    private String iv;

    @Schema(description = "iv向量编码规则（HEX, BASE64）")
    @JsonProperty("ivEncode")
    private String ivEncode = "BASE64";

    @Schema(description = "模式（ECB/CBC）")
    private String mode;

    @Schema(description = "原文（待加密数据）")
    private String plaintext;

    @Schema(description = "密文编码规则（HEX, BASE64）")
    private String plaintextEncode = "BASE64";

    @Schema(description = "输出结果编码规则（HEX, BASE64）")
    private String resEncode = "BASE64";

    public SM4EncryptRequest(String key, String keyEncode, String iv, String ivEncode, String mode, String plaintext, String plaintextEncode, String resEncode) {
        this.key = key;
        this.keyEncode = keyEncode;
        this.iv = iv;
        this.ivEncode = ivEncode;
        this.mode = mode;
        this.plaintext = plaintext;
        this.plaintextEncode = plaintextEncode;
        this.resEncode = resEncode;
    }

    public SM4EncryptRequest(String key, String iv, String mode, String plaintext) {
        this.key = key;
        this.iv = iv;
        this.mode = mode;
        this.plaintext = plaintext;
    }

    public String getKey() {
        return key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getKeyEncode() {
        return keyEncode;
    }

    public void setKeyEncode(String keyEncode) {
        this.keyEncode = keyEncode;
    }

    public String getIv() {
        return iv;
    }

    public void setIv(String iv) {
        this.iv = iv;
    }

    public String getIvEncode() {
        return ivEncode;
    }

    public void setIvEncode(String ivEncode) {
        this.ivEncode = ivEncode;
    }

    public String getMode() {
        return mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public String getPlaintext() {
        return plaintext;
    }

    public void setPlaintext(String plaintext) {
        this.plaintext = plaintext;
    }

    public String getPlaintextEncode() {
        return plaintextEncode;
    }

    public void setPlaintextEncode(String plaintextEncode) {
        this.plaintextEncode = plaintextEncode;
    }

    public String getResEncode() {
        return resEncode;
    }

    public void setResEncode(String resEncode) {
        this.resEncode = resEncode;
    }

}
