package cn.zjquantum.gm.api.request.sm4;

import io.swagger.v3.oas.annotations.media.Schema;

import java.io.Serializable;
import java.util.List;

@Schema(description = "SM4解密请求参数")
public class SM4GetKeyByKeyIdRequest implements Serializable {

    @Schema(description = "密钥")
    private List<String> keyIds;

    @Schema(description = "输出结果编码规则（HEX, BASE64）")
    private String resEncode = "BASE64";

    public SM4GetKeyByKeyIdRequest(List<String> keyIds, String resEncode) {
        this.keyIds = keyIds;
        this.resEncode = resEncode;
    }

    public SM4GetKeyByKeyIdRequest(List<String> keyIds) {
        this.keyIds = keyIds;
    }

    public List<String> getKeyIds() {
        return keyIds;
    }

    public void setKeyIds(List<String> keyIds) {
        this.keyIds = keyIds;
    }

    public String getResEncode() {
        return resEncode;
    }

    public void setResEncode(String resEncode) {
        this.resEncode = resEncode;
    }

}
