package cn.zjquantum.gm.api.response;

import java.io.Serializable;
import java.util.UUID;

public class R<T> implements Serializable {

    private String requestId;
    private int code;
    private String msg;
    private T data ;

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public int getCode() {
        return code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public String getMsg() {
        return msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public T getData() {
        return data;
    }

    public void setData(T data) {
        this.data = data;
    }

    public String getRequestId() {
        this.requestId = UUID.randomUUID().toString();
        return this.requestId;
    }

    public R(){
        this.requestId = this.getRequestId();
    }

    public static R ok() {
        R r = new R();
        r.code = 0;
        r.msg = "success";
        return r;
    }

    public static R ok(String msg) {
        R r = new R();
        r.code = 0;
        r.msg = msg;
        r.data = null;
        return r;
    }

    public static R ok(Object data) {
        R r = new R();
        r.code = 0;
        r.msg = "success";
        r.data = data;
        return r;
    }

    public static R ok(String msg, Object data) {
        R r = new R();
        r.code = 0;
        r.msg = msg;
        r.data = data;
        return r;
    }

    public static R fail(int code, String msg) {
        R r = new R();
        r.code = code;
        r.msg = msg;
        return r;
    }


}
