package cn.zjquantum.gm.api.response.sm4;

import io.swagger.v3.oas.annotations.media.Schema;

import java.io.Serializable;

@Schema(description = "SM4解密返回结果")
public class SM4DecryptResponse implements Serializable {

    @Schema(description = "原文（已解密数据）")
    private String plaintext;

    @Schema(description = "输出结果编码规则（UTF8, HEX, BASE64）")
    private String resEncode = "BASE64";

    public String getPlaintext() {
        return plaintext;
    }

    public void setPlaintext(String plaintext) {
        this.plaintext = plaintext;
    }

    public String getResEncode() {
        return resEncode;
    }

    public void setResEncode(String resEncode) {
        this.resEncode = resEncode;
    }

    public SM4DecryptResponse() {
    }

    public SM4DecryptResponse(String plaintext, String resEncode) {
        this.plaintext = plaintext;
        this.resEncode = resEncode;
    }
}
