package cn.zjquantum.gm.api.response.sm4;

import io.swagger.v3.oas.annotations.media.Schema;

import java.io.Serializable;

/**
 * @Author jerry
 * @Date 2024/12/20
 */
@Schema(description = "SM4密钥返回结果")
public class SM4KeyResponse implements Serializable {
    @Schema(description = "密钥编号")
    private String keyId;
    @Schema(description = "密钥值")
    private String keyValue;

    @Schema(description = "输出结果编码规则（HEX, BASE64）")
    private String resEncode = "BASE64";

    public String getKeyId() {
        return keyId;
    }

    public void setKeyId(String keyId) {
        this.keyId = keyId;
    }

    public String getKeyValue() {
        return keyValue;
    }

    public void setKeyValue(String keyValue) {
        this.keyValue = keyValue;
    }

    public String getResEncode() {
        return resEncode;
    }

    public void setResEncode(String resEncode) {
        this.resEncode = resEncode;
    }

    public SM4KeyResponse() {
    }

    public SM4KeyResponse(String keyId, String keyValue, String resEncode) {
        this.keyId = keyId;
        this.keyValue = keyValue;
        this.resEncode = resEncode;
    }
}
