# CM-SDK-JS
> 1.0.0

## SDK 使用说明

### 前置操作

1. 引入zjquantum-cm-sdk-1.0.0-release.js中的方法

2. 安装axios

### 使用流程

配置服务信息 -> 调用所需方法 -> 使用SDK返回的数据

### 功能

1.身份认证

2.根据所需密钥数量获取国密SM2非对称密钥

3.根据已知的密钥编号获取国密SM2非对称密钥

4.根据所需密钥数量获取国密SM4对称密钥

5.根据已知的密钥编号获取国密SM4对称密钥

6.国密SM4加密

7.国密SM4解密

8.国密SM3摘要计算

9.国密SM2签名计算

10.国密SM2签名验证

11.国密SM2加密算法

12.国密SM2解密算法

## 示例

### 0.初始化配置

```javascript

const IP = 'IP地址' // 默认值：'api.zjquantum.cn'
const port = '端口号' // 默认值：'80'
const clientId = 'clientId' //由SDK提供方提供
const clientSecret = 'clientSecret' //由SDK提供方提供
const pubKey = '公钥' //由SDK提供方提供
const priKey = '私钥' //由SDK提供方提供
let prefix = ''  //由SDK提供方提供，一般无需配置
zjquantumConfig(IP, port, prefix, clientId, clientSecret, pubKey, priKey)
```



### 1.身份认证

```javascript
const Login = async () => {
  try {
    const loginData = await login()
  } catch (error) {
    console.log(error)
  }
}
```

### 2.根据所需密钥数量获取国密SM2非对称密钥

```javascript
const sm2GetKeyNum = async () => {
  const resEncode = '输出结果编码规则' // 【HEX、BASE64】
  const number = '数量' // 正整数 
  try {
    const sm2KeyData = await getSm2KeyNum(resEncode,number)
    const result = sm2KeyData // 返回数组形式的密钥对
  } catch (error) {
    console.log(error)
  }
}
```
### 3.根据已知的密钥编号获取国密SM2非对称密钥

```javascript
const sm2GetKeyById = async () => {
  const resEncode = '输出结果编码规则' // 【HEX、BASE64】
  let keyIds = [] // 密钥对ID（支持多个）
  try {
    const sm2KeyIdData = await getSm2KeyId(resEncode,keyIds)
    const result = sm2KeyIdData // 返回数组形式的密钥对
  } catch (error) {
    console.log(error)
  }
}
```

### 4.根据所需密钥数量获取国密SM4对称密钥

```javascript
const sm4GetKeyByNum = async () => {
  const resEncode = '输出结果编码规则' // 【HEX、BASE64】
  const number = '数量' // 正整数 
  try {
    const sm4KeyNumData = await getSm4KeyNum(number,resEncode)
    const result = sm4KeyNumData // 返回数组形式的密钥
  } catch (error) {
    console.log(error)
  }
}
```

### 5.根据已知的密钥编号获取国密SM4对称密钥

```javascript
const sm4GetKeyById = async () => {
  const resEncode = '输出结果编码规则' // 【HEX、BASE64】
  let keyIds = [] // 密钥ID（支持多个）
  try {
    const sm4KeyIdData = await getSm4KeyId(keyIds,resEncode)
    const result = sm4KeyIdData // 返回数组形式的密钥
  } catch (error) {
    console.log(error)
  }
}
```

### 6.国密SM4加密（对称算法加解密）
```javascript
const sm4Encrypt = async () => {
const plaintextEncode = '原文数据编码规则' // 【UTF8、HEX、BASE64】
const keyEncode = '密钥编码规则' // 【HEX、BASE64】
const ivEncode = 'IV编码规则' // 【HEX、BASE64】
const resEncode = '输出结果编码规则' // 【HEX、BASE64】
const plaintext = '原文'
const key = '密钥'
const mode = 'ECB/CBC'
const IV = 'IV向量（CBC模式需要输入IV向量）'
try {
  const encryptedData = await symEncData(plaintextEncode, keyEncode, ivEncode,  resEncode, mode, plaintext, key, IV)
  const result = encryptedData // 加密后的密文
} catch (error) {
  console.log(error)
}
}
```

### 7.国密SM4解密

```javascript
const sm4Encrypt = async () => {
const ciphertextEncode = '密文数据编码规则' // 【HEX、BASE64】
const keyEncode = '密钥编码规则' // 【HEX、BASE64】
const ivEncode = 'IV编码规则' // 【HEX、BASE64】
const resEncode = '输出结果编码规则' // 【UTF8、HEX、BASE64】
const ciphertext = '密文'
const key = '密钥'
const mode = 'ECB/CBC'
const IV = 'IV向量（CBC模式需要输入IV向量）'
try {
  const decryptedData = await symDecData(ciphertextEncode, keyEncode, ivEncode, resEncode, mode, ciphertext, key, IV)
  const result = decryptedData // 解密后的原文
} catch (error) {
  console.log(error)
}
}
```

### 8.国密SM3摘要计算
```javascript
const sm3Hash = async () => {
  const messageEncode = '请求数据编码规则' // 【UTF8、HEX、BASE64】
  const resEncode = '输出结果编码规则' // 【HEX、BASE64】
  const message = '计算原文'
  try {
    const hashData = await hash(messageEncode, resEncode, message)
    const result = hashData // 计算后的结果
  } catch (error) {
    console.log(error)
  }
}
```

### 9.国密SM2签名计算

```javascript
const sm2Sign = async () => {
const plaintextEncode = '待签名数据编码规则' // 【UTF8、HEX、BASE64】
const keyEncode = '公私钥编码规则' // 【HEX、BASE64】
const userIDEncode = '用户ID编码规则' // 【UTF8、HEX、BASE64】
const resEncode = '输出结果编码规则' // 【HEX、BASE64】
const plaintext = '待签名数据'
const publicKey = '公钥'
const privateKey = '私钥'
const userID = 'userID'
try {
  const signData = await asymSign(plaintextEncode, keyEncode, userIDEncode, resEncode, publicKey, privateKey, userID, plaintext)
  const result = signData // 签名结果
} catch (error) {
  console.log(error)
}
}
```

### 10.国密SM2签名验证

```javascript
const sm2Verify = async () => {
const plaintextEncode = '验证数据编码规则' // 【UTF8、HEX、BASE64】
const keyEncode = '公钥编码规则' // 【HEX、BASE64】
const userIDEncode = '签名结果编码规则' // 【HEX、BASE64】
const signDataEncode = '用户ID编码规则' // 【UTF8、HEX、BASE64】
const plaintext = '验证数据'
const publicKey = '公钥'
const signData = '签名结果'
const userID = 'userID'
try {
  const verifyData = await asymVerify(plaintextEncode, keyEncode, userIDEncode, signDataEncode, publicKey, userID, signData, plaintext)
  const result = verifyData // 验签结果（true/false）
} catch (error) {
  console.log(error)
}
}
```

### 11.国密SM2加密算法

```javascript
const sm2Encrypt = async () => {
const plaintextEncode = '原文编码规则' // 【UTF8、HEX、BASE64】
const keyEncode = '公钥编码规则' // 【HEX、BASE64】
const resEncode = '输出结果编码规则' // 【HEX、BASE64】
const plaintext = '原文'
const publicKey = '公钥'
try {
  const encryptedData = await asymEncData(plaintextEncode, keyEncode, resEncode, publicKey, plaintext)
  const result = encryptedData // 加密后的密文
} catch (error) {
  console.log(error)
}
}
```

### 12.国密SM2解密算法

```javascript
const sm2Decrypt = async () => {
const ciphertextEncode = '密文编码规则' // 【HEX、BASE64】
const keyEncode = '私钥编码规则' // 【HEX、BASE64】
const resEncode = '输出结果编码规则' // 【UTF8、HEX、BASE64】
const ciphertext = '密文'
const privateKey = '私钥'
try {
  const decryptedData = await asymDecData(ciphertextEncode, keyEncode, resEncode, privateKey, ciphertext)
  const result = decryptedData // 解密后的原文
} catch (error) {
  console.log(error)
}
}
```
