import{hexToBase64Simpler,hexToBytes,bytesToHex,utf8ToBytes,base64ToBytes,bytesToUtf8,bytesToBase64}from"./transcoding.js";import{encrypt,decrypt}from"./sm/sm4";import{sm3Hash}from"./sm/sm3";import{doEncrypt,doDecrypt,doSignature,doVerifySignature}from"./sm/sm2";let serverPubKey="1FC6A3C876FC1EFA2129669AE05B762E061166981E5AEB9C21D0D26E77D1A8E494E086A47D2A769236C5B47265CE52B45BC203F3EEE207FD881243C577033DA6";let config={};export const zjquantumConfig=(ip,port,prefix,clientId,clientSecret,pubKey,priKey)=>{ip=ip||"api.zjquantum.cn";port=port||"80";if(prefix){if(!prefix.startsWith("/")){prefix="/"+prefix}else{prefix=prefix.replace(/^\/+/,"/");prefix=prefix.replace(/\/+$/,"")}}else{prefix="/sdk/cm/v1"}config={clientId:clientId,clientSecret:clientSecret,pubKey:pubKey,priKey:priKey,apiUrl:`http://${ip}:${port}${prefix}`};return config};let random="";function generateRandomBytes(){const array=new Uint8Array(16);window.crypto.getRandomValues(array);return array}let sessionKey="";let token="";export const login=async()=>{try{random=bytesToHex(generateRandomBytes()).toUpperCase();const params={clientId:config.clientId,ra:doEncrypt(hexToBytes(random),"04"+serverPubKey),clientSecret:sm3Hash(utf8ToBytes(config.clientSecret+random))};const response=await axios.post(`${config.apiUrl}/auth/getToken`,params);if(response.data.code!==0){throw new Error(response.data.msg)}token=response.data.data.token;const RB=doDecrypt(response.data.data.rb,config.priKey);sessionKey=xorHex(RB,random);return response.data}catch(error){console.log("login",error)}};function xorHex(hex1,hex2){let bigInt1=BigInt(`0x${hex1}`);let bigInt2=BigInt(`0x${hex2}`);let result=bigInt1^bigInt2;let hexResult=result.toString(16).toUpperCase();return hexResult}const instance=axios.create({baseURL:""});instance.interceptors.request.use(function(config){if(token){config.headers.Authorization=`Bearer ${token}`}return config},function(error){return Promise.reject(error)});export const getSm4KeyNum=async(number,resEncode)=>{try{const params={number:number,resEncode:resEncode};const response=await instance.post(`${config.apiUrl}/sm4/getKeyByNumber`,params);if(response.data.code!==0){const regex=/^[1-9]\d*$/;if(!regex.test(number)){throw new Error("请检查参数的合法性！")}else{throw new Error(response.data.msg)}}let keys=response.data.data.map(item=>{if(resEncode==="HEX"){return{keyId:item.keyId,key:decrypt(item.keyValue,sessionKey)}}else if(resEncode==="BASE64"){return{keyId:item.keyId,key:bytesToBase64(hexToBytes(decrypt(base64ToBytes(item.keyValue),sessionKey)))}}else{throw new Error("请检查结果编码规则！")}});return keys}catch(error){console.log(error)}};export const getSm4KeyId=async(keyIds,resEncode)=>{try{const params={keyIds:keyIds,resEncode:resEncode};const response=await instance.post(`${config.apiUrl}/sm4/getKeyByKeyId`,params);if(response.data.code!==0){throw new Error(response.data.msg)}let keys=response.data.data.map(item=>{if(resEncode==="HEX"){return{keyId:item.keyId,key:decrypt(item.keyValue,sessionKey)}}else if(resEncode==="BASE64"){return{keyId:item.keyId,key:bytesToBase64(hexToBytes(decrypt(base64ToBytes(item.keyValue),sessionKey)))}}else{throw new Error("请检查结果编码规则！")}});return keys}catch(error){console.log(error)}};export const symEncData=(plaintextEncode,keyEncode,ivEncode,resEncode,mode,plaintext,key,iv)=>{try{let msg="";switch(plaintextEncode){case"HEX":msg=hexToBytes(plaintext);break;case"BASE64":msg=base64ToBytes(plaintext);break;case"UTF8":msg=utf8ToBytes(plaintext);break;default:throw new Error("请检查原文编码规则！")}let Key="";switch(keyEncode){case"HEX":Key=key;break;case"BASE64":Key=bytesToHex(base64ToBytes(key));break;default:throw new Error("请检查密钥编码规则！")}let IV="";switch(ivEncode){case"HEX":IV=hexToBytes(iv);break;case"BASE64":IV=base64ToBytes(iv);break;case"UTF8":IV=utf8ToBytes(iv);break;default:throw new Error("请检查IV编码规则！")}const params={mode:mode,iv:IV};const response=encrypt(msg,Key,params);let res="";switch(resEncode){case"HEX":res=response;break;case"BASE64":res=bytesToBase64(hexToBytes(response));break;default:throw new Error("请检查结果编码规则！")}return res}catch(error){console.log(error)}};export const symDecData=(ciphertextEncode,keyEncode,ivEncode,resEncode,mode,ciphertext,key,iv)=>{try{let msg="";switch(ciphertextEncode){case"HEX":msg=ciphertext;break;case"BASE64":msg=bytesToHex(base64ToBytes(ciphertext));break;default:throw new Error("请检查密文编码规则！")}let Key="";switch(keyEncode){case"HEX":Key=key;break;case"BASE64":Key=bytesToHex(base64ToBytes(key));break;default:throw new Error("请检查密钥编码规则！")}let IV="";switch(ivEncode){case"HEX":IV=hexToBytes(iv);break;case"BASE64":IV=base64ToBytes(iv);break;case"UTF8":IV=utf8ToBytes(iv);break;default:throw new Error("请检查IV编码规则！")}const params={mode:mode,iv:IV};const response=decrypt(msg,Key,params);let res="";switch(resEncode){case"HEX":res=response;break;case"BASE64":res=bytesToBase64(hexToBytes(response));break;case"UTF8":res=bytesToUtf8(hexToBytes(response));break;default:throw new Error("请检查结果编码规则！")}return res}catch(error){console.log(error)}};export const hash=(messageEncode,resEncode,message)=>{try{let msg="";switch(messageEncode){case"HEX":msg=hexToBytes(message);break;case"BASE64":msg=base64ToBytes(message);break;case"UTF8":msg=utf8ToBytes(message);break;default:throw new Error("请检查原文编码规则！")}const response=sm3Hash(msg);let res="";switch(resEncode){case"HEX":res=response;break;case"BASE64":res=hexToBase64Simpler(response);break;default:throw new Error("请检查结果编码规则！")}return res}catch(error){console.log(error)}};export const getSm2KeyNum=async(resEncode,number)=>{try{const params={resEncode:resEncode,number:number};const response=await instance.post(`${config.apiUrl}/sm2/getKeyByNumber`,params);if(response.data.code!==0){const regex=/^[1-9]\d*$/;if(!regex.test(number)){throw new Error("请检查参数的合法性！")}else{throw new Error(response.data.msg)}}let key=response.data.data.map(item=>{if(resEncode==="HEX"){return{keyId:item.keyId,privateKey:decrypt(item.privateKey,sessionKey),publicKey:item.publicKey}}else if(resEncode==="BASE64"){return{keyId:item.keyId,privateKey:bytesToBase64(hexToBytes(decrypt(base64ToBytes(item.privateKey),sessionKey))),publicKey:item.publicKey}}else{throw new Error("请检查结果编码规则！")}});return key}catch(error){console.log(error)}};export const getSm2KeyId=async(resEncode,keyIds)=>{try{const params={resEncode:resEncode,keyIds:keyIds};const response=await instance.post(`${config.apiUrl}/sm2/getKeyByKeyId`,params);if(response.data.code!==0){throw new Error(response.data.msg)}let key=response.data.data.map(item=>{if(resEncode==="HEX"){return{keyId:item.keyId,privateKey:decrypt(item.privateKey,sessionKey),publicKey:item.publicKey}}else if(resEncode==="BASE64"){return{keyId:item.keyId,privateKey:bytesToBase64(hexToBytes(decrypt(base64ToBytes(item.privateKey),sessionKey))),publicKey:item.publicKey}}else{throw new Error("请检查结果编码规则！")}});return key}catch(error){console.log(error)}};export const asymEncData=(plaintextEncode,keyEncode,resEncode,publicKey,plaintext)=>{try{let msg="";switch(plaintextEncode){case"HEX":msg=hexToBytes(plaintext);break;case"BASE64":msg=base64ToBytes(plaintext);break;case"UTF8":msg=utf8ToBytes(plaintext);break;default:throw new Error("请检查原文编码规则！")}let key="";switch(keyEncode){case"HEX":key="04"+publicKey;break;case"BASE64":key="04"+bytesToHex(base64ToBytes(publicKey));break;default:throw new Error("请检查公钥编码规则！")}const response=doEncrypt(msg,key);let res="";switch(resEncode){case"HEX":res=response;break;case"BASE64":res=bytesToBase64(hexToBytes(response));break;default:throw new Error("请检查结果编码规则！")}return res}catch(error){console.log(error)}};export const asymDecData=(ciphertextEncode,keyEncode,resEncode,privateKey,ciphertext)=>{try{let msg="";switch(ciphertextEncode){case"HEX":msg=ciphertext;break;case"BASE64":msg=bytesToHex(base64ToBytes(ciphertext));break;default:throw new Error("请检查密文编码规则！")}let key="";switch(keyEncode){case"HEX":key=privateKey;break;case"BASE64":key=bytesToHex(base64ToBytes(privateKey));break;default:throw new Error("请检查私钥编码规则！")}const response=doDecrypt(msg,key);let res="";switch(resEncode){case"HEX":res=response;break;case"BASE64":res=bytesToBase64(hexToBytes(response));break;case"UTF8":res=bytesToUtf8(hexToBytes(response));break;default:throw new Error("请检查结果编码规则！")}return res}catch(error){console.log(error)}};export const asymSign=async(plaintextEncode,keyEncode,userIDEncode,resEncode,publicKey,privateKey,userID,plaintext)=>{try{let msg="";switch(plaintextEncode){case"HEX":msg=plaintext;break;case"BASE64":msg=bytesToHex(base64ToBytes(plaintext));break;case"UTF8":msg=bytesToHex(utf8ToBytes(plaintext));break;default:throw new Error("请检查原文编码规则！")}let pubkey="";switch(keyEncode){case"HEX":pubkey=publicKey;break;case"BASE64":pubkey=bytesToHex(base64ToBytes(publicKey));break;default:throw new Error("请检查公钥编码规则！")}let prikey="";switch(keyEncode){case"HEX":prikey=privateKey;break;case"BASE64":prikey=bytesToHex(base64ToBytes(privateKey));break;default:throw new Error("请检查私钥编码规则！")}let id="";switch(userIDEncode){case"HEX":id=userID;break;case"BASE64":id=bytesToHex(base64ToBytes(userID));break;case"UTF8":id=bytesToHex(utf8ToBytes(userID));break;default:throw new Error("请检查userID编码规则！")}const response=doSignature(msg,prikey,{hash:true,publicKey:pubkey,userId:id});let res="";switch(resEncode){case"HEX":res=response;break;case"BASE64":res=bytesToBase64(hexToBytes(response));break;default:throw new Error("请检查结果编码规则！")}return res}catch(error){console.log(error)}};export const asymVerify=(plaintextEncode,keyEncode,userIDEncode,signDataEncode,publicKey,userID,signData,plaintext)=>{try{let msg="";switch(plaintextEncode){case"HEX":msg=plaintext;break;case"BASE64":msg=bytesToHex(base64ToBytes(plaintext));break;case"UTF8":msg=bytesToHex(utf8ToBytes(plaintext));break;default:throw new Error("请检查验证数据（原文）编码规则！")}let pubkey="";switch(keyEncode){case"HEX":pubkey="04"+publicKey;break;case"BASE64":pubkey="04"+bytesToHex(base64ToBytes(publicKey));break;default:throw new Error("请检查公钥编码规则！")}let signMsg="";switch(signDataEncode){case"HEX":signMsg=signData;break;case"BASE64":signMsg=bytesToHex(base64ToBytes(signData));break;default:throw new Error("请检查签名结果编码规则！")}let id="";switch(userIDEncode){case"HEX":id=userID;break;case"BASE64":id=bytesToHex(base64ToBytes(userID));break;case"UTF8":id=bytesToHex(utf8ToBytes(userID));break;default:throw new Error("请检查userID编码规则！")}const response=doVerifySignature(msg,signMsg,pubkey,{hash:true,userId:id});return response}catch(error){console.log(error)}};