package cn.zjquantum.gm.api.request.sm2;

import io.swagger.v3.oas.annotations.media.Schema;

import java.io.Serializable;

@Schema(description = "SM2解密请求参数")
public class SM2DecryptRequest implements Serializable {

    @Schema(description = "私钥")
    private String privateKey;

    @Schema(description = "私钥编码规则（HEX, BASE64）")
    private String keyEncode = "BASE64";

    @Schema(description = "密文（待解密数据）")
    private String ciphertext;

    @Schema(description = "密文编码规则（HEX, BASE64）")
    private String ciphertextEncode = "BASE64";

    @Schema(description = "输出结果编码规则（UTF8, HEX, BASE64）")
    private String resEncode = "UTF8";

    public SM2DecryptRequest(String privateKey, String keyEncode, String ciphertext, String ciphertextEncode, String resEncode) {
        this.privateKey = privateKey;
        this.keyEncode = keyEncode;
        this.ciphertext = ciphertext;
        this.ciphertextEncode = ciphertextEncode;
        this.resEncode = resEncode;
    }

    public SM2DecryptRequest(String privateKey, String ciphertext) {
        this.privateKey = privateKey;
        this.ciphertext = ciphertext;
    }

    public String getPrivateKey() {
        return privateKey;
    }

    public void setPrivateKey(String privateKey) {
        this.privateKey = privateKey;
    }

    public String getCiphertext() {
        return ciphertext;
    }

    public void setCiphertext(String ciphertext) {
        this.ciphertext = ciphertext;
    }

    public String getKeyEncode() {
        return keyEncode;
    }

    public void setKeyEncode(String keyEncode) {
        this.keyEncode = keyEncode;
    }

    public String getCiphertextEncode() {
        return ciphertextEncode;
    }

    public void setCiphertextEncode(String ciphertextEncode) {
        this.ciphertextEncode = ciphertextEncode;
    }

    public String getResEncode() {
        return resEncode;
    }

    public void setResEncode(String resEncode) {
        this.resEncode = resEncode;
    }

}
