package cn.zjquantum.gm.api.request.sm2;

import io.swagger.v3.oas.annotations.media.Schema;

@Schema(description = "SM2解密请求参数")
public class SM2KeyGenerateByNumberRequest {

    @Schema(description = "请求数量")
    private Integer number;

    @Schema(description = "输出结果编码规则（HEX, BASE64）")
    private String resEncode = "BASE64";

    public SM2KeyGenerateByNumberRequest(Integer number, String resEncode) {
        this.number = number;
        this.resEncode = resEncode;
    }

    public SM2KeyGenerateByNumberRequest(Integer number) {
        this.number = number;
    }

    public Integer getNumber() {
        return number;
    }

    public void setNumber(Integer number) {
        this.number = number;
    }

    public String getResEncode() {
        return resEncode;
    }

    public void setResEncode(String resEncode) {
        this.resEncode = resEncode;
    }
}
