package cn.zjquantum.gm.api.request.sm2;

import io.swagger.v3.oas.annotations.media.Schema;

import java.io.Serializable;

@Schema(description = "SM2数字签名请求参数")
public class SM2SignRequest implements Serializable {

    @Schema(description = "公钥")
    private String publicKey;

    @Schema(description = "私钥")
    private String privateKey;

    @Schema(description = "公钥和私钥编码规则（HEX, BASE64）")
    private String keyEncode = "BASE64";

    @Schema(description = "用户ID")
    private String userID;

    @Schema(description = "用户ID编码规则（UTF8, HEX, BASE64）")
    private String userIDEncode = "UTF8";

    @Schema(description = "待签名数据")
    private String plaintext;

    @Schema(description = "待签名数据编码规则（UTF8, HEX, BASE64）")
    private String plaintextEncode = "UTF8";

    @Schema(description = "输出结果编码规则（HEX, BASE64）")
    private String resEncode = "BASE64";

    public SM2SignRequest(String publicKey, String privateKey, String keyEncode, String userID, String userIDEncode, String plaintext, String plaintextEncode, String resEncode) {
        this.publicKey = publicKey;
        this.privateKey = privateKey;
        this.keyEncode = keyEncode;
        this.userID = userID;
        this.userIDEncode = userIDEncode;
        this.plaintext = plaintext;
        this.plaintextEncode = plaintextEncode;
        this.resEncode = resEncode;
    }

    public SM2SignRequest(String publicKey, String privateKey, String userID, String plaintext) {
        this.publicKey = publicKey;
        this.privateKey = privateKey;
        this.userID = userID;
        this.plaintext = plaintext;
    }

    public String getPublicKey() {
        return publicKey;
    }

    public void setPublicKey(String publicKey) {
        this.publicKey = publicKey;
    }

    public String getPrivateKey() {
        return privateKey;
    }

    public void setPrivateKey(String privateKey) {
        this.privateKey = privateKey;
    }

    public String getKeyEncode() {
        return keyEncode;
    }

    public void setKeyEncode(String keyEncode) {
        this.keyEncode = keyEncode;
    }

    public String getUserID() {
        return userID;
    }

    public void setUserID(String userID) {
        this.userID = userID;
    }

    public String getUserIDEncode() {
        return userIDEncode;
    }

    public void setUserIDEncode(String userIDEncode) {
        this.userIDEncode = userIDEncode;
    }

    public String getPlaintext() {
        return plaintext;
    }

    public void setPlaintext(String plaintext) {
        this.plaintext = plaintext;
    }

    public String getPlaintextEncode() {
        return plaintextEncode;
    }

    public void setPlaintextEncode(String plaintextEncode) {
        this.plaintextEncode = plaintextEncode;
    }

    public String getResEncode() {
        return resEncode;
    }

    public void setResEncode(String resEncode) {
        this.resEncode = resEncode;
    }

}
