package cn.zjquantum.gm.api.request.sm2;

import io.swagger.v3.oas.annotations.media.Schema;

import java.io.Serializable;

@Schema(description = "SM2验证签名请求参数")
public class SM2VerifyRequest implements Serializable {

    @Schema(description = "公钥")
    private String publicKey;

    @Schema(description = "公钥编码规则（HEX, BASE64）")
    private String keyEncode = "BASE64";

    @Schema(description = "用户ID")
    private String userID;

    @Schema(description = "用户ID编码规则（UTF8,HEX, BASE64）")
    private String userIDEncode = "UTF8";

    @Schema(description = "签名数据")
    private String signData;

    @Schema(description = "签名数据编码规则（HEX, BASE64）")
    private String signDataEncode = "BASE64";

    @Schema(description = "验证数据")
    private String plaintext;

    @Schema(description = "验证数据编码规则（HEX, BASE64）")
    private String plaintextEncode = "BASE64";

    public SM2VerifyRequest(String publicKey, String keyEncode, String userID, String userIDEncode, String signData, String signDataEncode, String plaintext, String plaintextEncode) {
        this.publicKey = publicKey;
        this.keyEncode = keyEncode;
        this.userID = userID;
        this.userIDEncode = userIDEncode;
        this.signData = signData;
        this.signDataEncode = signDataEncode;
        this.plaintext = plaintext;
        this.plaintextEncode = plaintextEncode;
    }

    public SM2VerifyRequest(String publicKey, String userID, String signData, String plaintext) {
        this.publicKey = publicKey;
        this.userID = userID;
        this.signData = signData;
        this.plaintext = plaintext;
    }

    public String getPublicKey() {
        return publicKey;
    }

    public void setPublicKey(String publicKey) {
        this.publicKey = publicKey;
    }

    public String getKeyEncode() {
        return keyEncode;
    }

    public void setKeyEncode(String keyEncode) {
        this.keyEncode = keyEncode;
    }

    public String getUserID() {
        return userID;
    }

    public void setUserID(String userID) {
        this.userID = userID;
    }

    public String getUserIDEncode() {
        return userIDEncode;
    }

    public void setUserIDEncode(String userIDEncode) {
        this.userIDEncode = userIDEncode;
    }

    public String getSignData() {
        return signData;
    }

    public void setSignData(String signData) {
        this.signData = signData;
    }

    public String getSignDataEncode() {
        return signDataEncode;
    }

    public void setSignDataEncode(String signDataEncode) {
        this.signDataEncode = signDataEncode;
    }

    public String getPlaintext() {
        return plaintext;
    }

    public void setPlaintext(String plaintext) {
        this.plaintext = plaintext;
    }

    public String getPlaintextEncode() {
        return plaintextEncode;
    }

    public void setPlaintextEncode(String plaintextEncode) {
        this.plaintextEncode = plaintextEncode;
    }

}
