package cn.zjquantum.gm.api.response.sm2;

import io.swagger.v3.oas.annotations.media.Schema;

import java.io.Serializable;

@Schema(description = "SM2密钥对返回结果")
public class SM2KeyPairResponse implements Serializable {

    @Schema(description = "密钥编号")
    private String keyId;

    @Schema(description = "公钥")
    private String publicKey;

    @Schema(description = "私钥")
    private String privateKey;

    @Schema(description = "输出结果编码规则（HEX, BASE64）")
    private String resEncode = "BASE64";

    public String getKeyId() {
        return keyId;
    }

    public void setKeyId(String keyId) {
        this.keyId = keyId;
    }

    public String getPublicKey() {
        return publicKey;
    }

    public void setPublicKey(String publicKey) {
        this.publicKey = publicKey;
    }

    public String getPrivateKey() {
        return privateKey;
    }

    public void setPrivateKey(String privateKey) {
        this.privateKey = privateKey;
    }

    public String getResEncode() {
        return resEncode;
    }

    public void setResEncode(String resEncode) {
        this.resEncode = resEncode;
    }

    public SM2KeyPairResponse() {
    }

    public SM2KeyPairResponse(String keyId, String publicKey, String privateKey, String resEncode) {
        this.keyId = keyId;
        this.publicKey = publicKey;
        this.privateKey = privateKey;
        this.resEncode = resEncode;
    }
}
