package cn.zjquantum.gm.api.response.sm2;

import io.swagger.v3.oas.annotations.media.Schema;

import java.io.Serializable;

@Schema(description = "SM2数字签名返回结果")
public class SM2SignResponse implements Serializable {

    @Schema(description = "签名结果")
    private String signResult;

    @Schema(description = "签名结果编码规则（HEX, BASE64）")
    private String resEncode = "BASE64";

    public String getSignResult() {
        return signResult;
    }

    public void setSignResult(String signResult) {
        this.signResult = signResult;
    }

    public String getResEncode() {
        return resEncode;
    }

    public void setResEncode(String resEncode) {
        this.resEncode = resEncode;
    }

    public SM2SignResponse() {
    }

    public SM2SignResponse(String signResult, String resEncode) {
        this.signResult = signResult;
        this.resEncode = resEncode;
    }
}
