package cn.zjquantum.gm.api.response.sm3;

import io.swagger.v3.oas.annotations.media.Schema;

import java.io.Serializable;

@Schema(description = "SM3摘要计算返回结果")
public class SM3HashResponse implements Serializable {

    @Schema(description = "摘要计算结果")
    private String hashText;

    @Schema(description = "结果编码规则（HEX, BASE64）")
    private String resEncode = "BASE64";

    public String getHashText() {
        return hashText;
    }

    public void setHashText(String hashText) {
        this.hashText = hashText;
    }

    public String getResEncode() {
        return resEncode;
    }

    public void setResEncode(String resEncode) {
        this.resEncode = resEncode;
    }

    public SM3HashResponse() {
    }

    public SM3HashResponse(String hashText, String resEncode) {
        this.hashText = hashText;
        this.resEncode = resEncode;
    }
}
